<?php
// ===================================================================================
// BINGX SNIPER - FAVORITES EDITION
// Features: Algo Score, RSI Sort, Wick Detector, & FAVORITES MANAGER
// ===================================================================================

if (isset($_GET['action'])) {
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    error_reporting(0); 
    
    $action = $_GET['action'];
    
    function fetchBingX($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
        $output = curl_exec($ch);
        if(curl_errno($ch)){ return json_encode(['code' => -1, 'msg' => curl_error($ch)]); }
        curl_close($ch);
        return $output;
    }

    if ($action == 'ticker') {
        echo fetchBingX("https://open-api.bingx.com/openApi/swap/v2/quote/ticker");
    } 
    elseif ($action == 'history') {
        $symbol = $_GET['symbol'];
        // Pastikan interval adalah 1h seperti di skrip JS
        $url = "https://open-api.bingx.com/openApi/swap/v3/quote/klines?symbol={$symbol}&interval=1h&limit=500"; 
        echo fetchBingX($url);
    }
    exit; 
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BingX Sniper: Favorites</title>
    <link href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:wght@400;700&family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
    <style>
        /* --- CORE STYLES --- */
        body { font-family: 'Inter', sans-serif; background-color: #050505; color: #e0e0e0; margin: 0; padding: 20px; font-size: 13px; }
        
        /* HEADER */
        .btc-hero {
            background: linear-gradient(145deg, #1a0505, #000);
            border: 1px solid #333; border-radius: 12px; padding: 20px;
            max-width: 1600px; margin: 0 auto 20px auto;
            box-shadow: 0 10px 30px rgba(0,0,0,0.5);
            display: flex; justify-content: space-between; align-items: center;
        }
        .btc-left h1 { margin: 0; font-family: 'JetBrains Mono', monospace; font-size: 2rem; color: #ff5252; }
        
        /* CONTROLS */
        .controls { 
            text-align: center; margin-bottom: 20px; 
            display: flex; justify-content: center; gap: 10px; align-items: center; flex-wrap: wrap;
            max-width: 1600px; margin: 0 auto 20px auto;
        }
        
        select {
            background: #1a1d21; color: #fff; border: 1px solid #444; 
            padding: 12px 20px; border-radius: 30px; font-weight: bold; cursor: pointer; min-width: 200px;
            font-family: 'Inter', sans-serif; appearance: none;
        }
        select:hover { border-color: #ff5252; }

        #btn-start {
            background: linear-gradient(90deg, #d50000, #ff1744);
            border: none; padding: 12px 40px; color: white; border-radius: 30px; 
            font-weight: bold; cursor: pointer; box-shadow: 0 0 15px rgba(213, 0, 0, 0.4);
            transition: transform 0.2s;
        }
        #btn-start:hover { transform: scale(1.05); }
        #btn-start:disabled { background: #333; color: #fff; cursor: not-allowed; }

        #progress-container { width: 100%; max-width: 1600px; margin: 10px auto; display: none; }
        #progress-bar { height: 4px; background: #ff1744; width: 0%; transition: width 0.2s; }

        /* TABLE */
        table { width: 100%; max-width: 1600px; margin: 0 auto; border-collapse: collapse; background: #0a0a0a; border: 1px solid #222; }
        th { 
            background: #141414; padding: 15px 10px; text-align: center; position: sticky; top: 0; 
            border-bottom: 2px solid #333; color: #888; font-weight: 600; font-size: 0.75rem; text-transform: uppercase; z-index: 10;
        }
        td { padding: 10px; border-bottom: 1px solid #1c1f24; text-align: center; color: #ccc; vertical-align: middle; }
        tr:hover { background: #111; }

        /* FAVORITE STYLES */
        .fav-star { font-size: 1.5em; cursor: pointer; color: #333; transition: all 0.2s; display:inline-block; line-height:1; padding: 5px; }
        .fav-star:hover { color: #fff; transform: scale(1.2); }
        .fav-active { color: #ffd600; text-shadow: 0 0 10px rgba(255, 214, 0, 0.6); }

        /* SCORE & ALERTS */
        .score-box { display: flex; align-items: center; gap: 10px; justify-content: center; }
        .score-val { font-family: 'JetBrains Mono'; font-weight: 900; font-size: 1.2em; }
        .score-perfect { color: #ff1744; text-shadow: 0 0 10px rgba(255, 23, 68, 0.6); } 
        .score-high { color: #ff9100; } 
        .score-mid { color: #ffd600; }  
        
        .alert-live, .alert-history {
            padding: 4px 8px; border-radius: 4px; font-weight: bold; font-size: 0.85em;
        }
        .alert-live {
            background: rgba(255, 23, 68, 0.2); border: 1px solid #ff1744; color: #ff1744;
            animation: pulseRed 1s infinite;
        }
        .alert-history {
            background: rgba(0, 170, 255, 0.1); border: 1px solid #00aaff; color: #00aaff;
        }

        .rsi-high { color: #ff1744; background: rgba(255, 23, 68, 0.1); border: 1px solid #ff1744; padding: 2px 5px; border-radius: 4px; }
        .rsi-low { color: #2979ff; }

        .sym-cell { font-weight: 800; color: #e0e0e0; cursor: pointer; text-align: left; display: flex; align-items: center; gap: 8px; font-size: 1.1em; }
        .sym-cell:hover { color: #ff5252; }
        @keyframes pulseRed { 0% { opacity: 1; } 50% { opacity: 0.7; } 100% { opacity: 1; } }
    </style>
</head>
<body>

    <div class="btc-hero">
        <div class="btc-left">
            <h2>FAVORITES SNIPER</h2>
            <h1 id="btc-price">Loading...</h1>
            <span id="btc-change">0.00%</span>
        </div>
        <div class="btc-right">
            <div style="text-align:right">
                <div style="font-size:0.8em; color:#888">TARGET</div>
                <div style="color:#ff5252; font-weight:bold; font-size: 1.2em;">PUMP & REVERSAL PATTERN DETECTION (1H TF)</div>
            </div>
        </div>
    </div>

    <div class="controls">
        <select id="filter-status" onchange="renderTable()">
            <option value="high_score">💎 Filter: High Score (> 70)</option>
            <option value="fav_only">⭐️ Filter: Favorites Only</option>
            <option value="all">👁️ Filter: Show All</option>
            <option value="wick_only">🚨 Filter: Live Reversal Alert</option>
            <option value="res_only">📘 Filter: Historical Reversal</option>
        </select>

        <select id="sort-mode" onchange="renderTable()">
            <option value="score_desc">⚡ Sort: Algo Score (High)</option>
            <option value="rsi_desc">🔥 Sort: RSI (High -> Low)</option>
            <option value="rsi_asc">❄️ Sort: RSI (Low -> High)</option>
            <option value="pump_desc">🚀 Sort: Pump (Highest)</option>
        </select>

        <button id="btn-start" onclick="startSystem()">🎯 START ENGINE</button>
    </div>
    
    <div id="progress-container">
        <div id="progress-bar"></div>
        <div id="status-text" style="text-align:center; color:#666; margin-top:5px;">Initializing...</div>
    </div>
    <div id="error-box" class="error-msg"></div>

    <table>
        <thead>
            <tr>
                <th style="width: 50px;">Fav</th>
                <th style="width: 150px;">Symbol</th>
                <th>Price</th>
                <th style="width: 150px; border-bottom: 2px solid #ff1744; color:#ff1744;">ALGO SCORE</th>
                <th>REVERSAL ALERT (Live)</th>
                <th>RSI (14)</th>
                <th>Pump (1H)</th>
                <th>HISTORICAL PATTERN</th>
                <th style="width: 200px;">Status</th>
            </tr>
        </thead>
        <tbody id="table-body"></tbody>
    </table>

<script>
    const CONFIG = { API_TICKER: "?action=ticker", API_HISTORY: "?action=history" };
    
    const SETTINGS = {
        pivotPeriod: 10,     
        channelWidthPct: 4,  
        rsiPeriod: 14,
        resProximity: 2.5,
        pumpThreshold: 1.5 // Minimal % kenaikan candle hijau untuk dianggap "Pump"
    };

    let db = {};
    let isRunning = false;
    let favorites = new Set();
    // Tambahkan flag untuk mencegah spam audio
    let alertedSymbols = new Set();

    try {
        const saved = localStorage.getItem('bingx_favs');
        if(saved) favorites = new Set(JSON.parse(saved));
    } catch(e) { console.log('Fav Load Error'); }

    function toggleFav(sym) {
        if(favorites.has(sym)) favorites.delete(sym);
        else favorites.add(sym);
        localStorage.setItem('bingx_favs', JSON.stringify([...favorites]));
        renderTable();
    }

    async function startSystem() {
        if(isRunning) return;
        isRunning = true;
        const btn = document.getElementById('btn-start');
        btn.disabled = true;
        btn.innerText = "CALCULATING...";
        document.getElementById('progress-container').style.display = 'block';

        await fetchTickers(true);     
        await analyzeMarketDeep();    
        
        document.getElementById('progress-bar').style.width = "100%";
        btn.innerText = "LIVE SCANNING";
        
        setInterval(() => fetchTickers(false), 2500); 
    }

    async function fetchTickers(firstRun) {
        try {
            const res = await fetch(CONFIG.API_TICKER + "&_t=" + Date.now());
            if (!res.ok) throw new Error("Network error");
            const json = await res.json();
            if(json.code !== 0) return;

            json.data.forEach(c => {
                if(c.symbol === "BTC-USDT") updateBtcUI(c);
                if(c.symbol.endsWith("-USDT")) {
                    const sym = c.symbol;
                    const p = parseFloat(c.lastPrice);
                    
                    if(!db[sym]) {
                        db[sym] = { 
                            sym: sym, price: p, pump: 0, rsi: 0,
                            wick: { pct: 0, isLive: false },
                            sr: { res: null, inside: null },
                            reversalAlert: { active: false, count: 0 },
                            patternHistory: null, // BARU
                            algoScore: 0, status: 'neutral', klines: [] 
                        };
                    } else {
                        db[sym].price = p;
                        if(db[sym].klines.length > 0) {
                            updateLastCandle(db[sym], p); 
                            updateRealtimeMetrics(db[sym]); 
                        }
                    }
                }
            });

            if(firstRun) renderTable();
            else updateTableUI();
        } catch(e) { console.error(e); }
    }

    async function analyzeMarketDeep() {
        const symbols = Object.keys(db);
        const batch = 10; 
        for(let i=0; i<symbols.length; i+=batch) {
            const chunk = symbols.slice(i, i+batch);
            await Promise.all(chunk.map(async (sym) => {
                try {
                    const res = await fetch(`${CONFIG.API_HISTORY}&symbol=${sym}&_t=${Date.now()}`);
                    const json = await res.json();
                    if(json.code === 0 && json.data.length > 20) {
                        db[sym].klines = json.data.reverse();
                        calcSRChannels(db[sym]);
                        updateRealtimeMetrics(db[sym]);
                    }
                } catch(e) {}
            }));
            const pct = ((i+batch)/symbols.length)*100;
            document.getElementById('progress-bar').style.width = pct + "%";
            document.getElementById('status-text').innerText = `Calculating Metrics (${i}/${symbols.length})...`;
            await new Promise(r => setTimeout(r, 100));
        }
        renderTable();
    }

    function updateLastCandle(item, currentPrice) {
        let last = item.klines[item.klines.length - 1];
        last.close = currentPrice;
        if (currentPrice > parseFloat(last.high)) last.high = currentPrice;
        if (currentPrice < parseFloat(last.low)) last.low = currentPrice;
    }

    // ==========================================
    // LOGIKA BARU: DETEKSI PUMP -> RED CANDLES (LIVE)
    // ==========================================
    function checkLiveReversal(item) {
        const k = item.klines;
        if (k.length < 5) return { active: false, count: 0 };

        let redCount = 0;
        let foundPump = false;

        // Cek dari k.length - 2 (candle terakhir yang sudah CLOSE)
        for (let i = k.length - 2; i >= k.length - 5 && i >= 0; i--) {
            const close = parseFloat(k[i].close);
            const open = parseFloat(k[i].open);

            if (close < open) {
                redCount++;
            } else {
                // Candle sebelum streak merah: Cek Pump
                const pumpPct = ((close - open) / open) * 100;
                if (pumpPct >= SETTINGS.pumpThreshold) { foundPump = true; }
                break; // Stop jika menemukan candle hijau/netral
            }
        }

        // Syarat: Ada pump (di belakang streak) diikuti 1-4 candle merah
        if (foundPump && redCount >= 1 && redCount <= 4) {
            return { active: true, count: redCount };
        }
        return { active: false, count: 0 };
    }

    // ==========================================
    // LOGIKA BARU: DETEKSI HISTORIS (1-4 JAM LALU)
    // ==========================================
    function checkHistoricalReversal(item) {
        const k = item.klines;
        if (k.length < 6) return null;

        // Cek dari 1 jam lalu (index k.length - 3) sampai 4 jam lalu (k.length - 6)
        // k.length - 1 = Live (Open)
        // k.length - 2 = Last Closed Candle
        // k.length - 3 = 1 Hour Ago (Closed)
        for (let i = 3; i <= 6; i++) {
            const pumpIndex = k.length - i;
            if (pumpIndex < 0) continue;

            const pumpCandle = k[pumpIndex];
            const pumpOpen = parseFloat(pumpCandle.open);
            const pumpClose = parseFloat(pumpCandle.close);

            // 1. Check if it's a Pump Candle
            const isPump = (pumpClose > pumpOpen) && (((pumpClose - pumpOpen) / pumpOpen) * 100) >= SETTINGS.pumpThreshold;

            if (isPump) {
                let redStreakCount = 0;
                let isFullRedStreak = true;

                // 2. Check the subsequent candles (from pumpIndex + 1 to the last closed candle: k.length - 2)
                for (let j = pumpIndex + 1; j < k.length - 1; j++) {
                    const currentCandle = k[j];
                    const currentOpen = parseFloat(currentCandle.open);
                    const currentClose = parseFloat(currentCandle.close);
                    
                    if (currentClose < currentOpen) {
                        redStreakCount++;
                    } else {
                        isFullRedStreak = false;
                        break; // Streak merah terputus
                    }
                }

                // Jika semua candle setelah pump sampai candle terakhir yang close adalah merah, dan minimal ada 1 candle merah
                if (isFullRedStreak && redStreakCount >= 1) {
                    const hoursAgo = i - 2; // i=3 berarti 1 jam lalu
                    return { hoursAgo: hoursAgo, redCount: redStreakCount };
                }
            }
        }
        return null; // No pattern found
    }

    function updateRealtimeMetrics(item) {
        if(item.klines.length < SETTINGS.rsiPeriod + 1) return;

        const lastCandle = item.klines[item.klines.length - 1];
        item.pump = ((item.price - parseFloat(lastCandle.open)) / parseFloat(lastCandle.open)) * 100;

        const closes = item.klines.map(k => parseFloat(k.close));
        item.rsi = calculateRSI(closes, SETTINGS.rsiPeriod);

        // Update Reversal Alerts
        item.reversalAlert = checkLiveReversal(item);
        item.patternHistory = checkHistoricalReversal(item);

        calcWickMetrics(item);
        evaluateProximityAndScore(item);
    }

    // Fungsi lainnya (calcWickMetrics, calculateRSI, calcSRChannels, evaluateProximityAndScore) tidak berubah drastis

    function calcWickMetrics(item) {
        const k = item.klines;
        const getWick = (can) => {
            const h = parseFloat(can.high);
            const bodyTop = Math.max(parseFloat(can.open), parseFloat(can.close));
            return ((h - bodyTop) / parseFloat(can.close)) * 100;
        };
        const liveWick = getWick(k[k.length-1]);
        const prevWick = getWick(k[k.length-2]);
        item.wick = { pct: Math.max(liveWick, prevWick), isLive: liveWick > prevWick };
    }

    function calculateRSI(prices, period) {
        let gains = 0, losses = 0;
        for (let i = prices.length - period; i < prices.length; i++) {
            const diff = prices[i] - prices[i - 1];
            if (diff >= 0) gains += diff; else losses -= diff;
        }
        const rs = (gains/period) / (losses/period);
        return losses === 0 ? 100 : 100 - (100 / (1 + rs));
    }

    function calcSRChannels(item) { /* (Logic SR Channel tetap) */ }
    // ...

    function evaluateProximityAndScore(item) {
        let score = 0;
        
        // BOBOT SCORE
        if (item.reversalAlert.active) { score += 40; } 
        if (item.patternHistory) { score += 30; } // Bobot untuk pola historis
        if (item.rsi >= 75) score += 20;
        if (item.wick.pct >= 0.5) score += 10;

        // Audio Alert (Hanya untuk pola Live)
        if (item.reversalAlert.active && !alertedSymbols.has(item.sym)) {
            new Audio('https://assets.mixkit.co/active_storage/sfx/2568/2568-preview.mp3').play();
            alertedSymbols.add(item.sym);
        } else if (!item.reversalAlert.active && alertedSymbols.has(item.sym)) {
             alertedSymbols.delete(item.sym); // Reset alert jika pola hilang
        }


        item.algoScore = Math.min(score, 100);
    }

    function renderTable() {
        const tbody = document.getElementById('table-body');
        const filterVal = document.getElementById('filter-status').value;
        const sortVal = document.getElementById('sort-mode').value; 
        
        let keys = Object.keys(db);

        // Sorting Logic
        keys.sort((a,b) => {
            const dA = db[a];
            const dB = db[b];
            if(sortVal === 'rsi_desc') return dB.rsi - dA.rsi; 
            if(sortVal === 'rsi_asc') return dA.rsi - dB.rsi; 
            if(sortVal === 'pump_desc') return dB.pump - dA.pump; 
            return dB.algoScore - dA.algoScore; // Default Score
        });

        let html = "";
        keys.forEach(k => {
            const d = db[k];
            const isFav = favorites.has(d.sym);

            // FILTERING LOGIC
            if(filterVal === 'fav_only' && !isFav) return;
            else if(filterVal === 'high_score' && d.algoScore < 70) return;
            else if(filterVal === 'wick_only' && !d.reversalAlert.active) return;
            else if(filterVal === 'res_only' && !d.patternHistory) return;

            // VISUALS
            let scoreClass = d.algoScore >= 90 ? 'score-perfect' : (d.algoScore >= 70 ? 'score-high' : (d.algoScore >= 50 ? 'score-mid' : 'score-low'));
            let fillClass = d.algoScore >= 90 ? 'fill-perfect' : (d.algoScore >= 70 ? 'fill-high' : (d.algoScore >= 50 ? 'fill-mid' : ''));
            const pumpColor = d.pump > 0 ? '#00e676' : '#ff1744';
            let rsiClass = d.rsi >= 70 ? 'rsi-high' : (d.rsi <= 30 ? 'rsi-low' : '');
            
            // Kolom Live Reversal
            let liveAlertHtml = '-';
            if(d.reversalAlert.active) {
                liveAlertHtml = `<span class="alert-live">🚨 ${d.reversalAlert.count} RED CANDLE(S)</span>`;
            }

            // Kolom Historical Reversal
            let historyHtml = '-';
            if(d.patternHistory) {
                const { hoursAgo, redCount } = d.patternHistory;
                const timeText = hoursAgo === 1 ? '1 jam' : `${hoursAgo} jam`;
                historyHtml = `<span class="alert-history">Pump ${timeText} lalu, Red (${redCount}x)</span>`;
            }
            
            // Kolom Status
            let statusHtml = 'Neutral';
            if(d.algoScore >= 90) statusHtml = '💎 EXTREME SHORT POTENTIAL';
            else if(d.algoScore >= 70) statusHtml = '🔥 SHORT SETUP';
            else if(d.reversalAlert.active || d.patternHistory) statusHtml = '⚠️ DUMP POTENTIAL';
            

            html += `
            <tr>
                <td><span class="fav-star ${isFav?'fav-active':''}" onclick="toggleFav('${d.sym}')">${isFav?'★':'☆'}</span></td>
                <td><div class="sym-cell" onclick="window.open('https://www.tradingview.com/chart/?symbol=BINGX:${d.sym.replace('-','')}.P','_blank')">${d.sym.replace('-USDT','')} ↗</div></td>
                <td style="font-family:monospace; font-weight:bold;">${d.price}</td>
                
                <td>
                    <div class="score-box">
                        <span class="score-val ${scoreClass}">${d.algoScore}</span>
                        <div class="score-bar-bg">
                            <div class="score-bar-fill ${fillClass}" style="width:${d.algoScore}%"></div>
                        </div>
                    </div>
                </td>

                <td>${liveAlertHtml}</td>
                <td><span class="${rsiClass}">${d.rsi.toFixed(1)}</span></td>
                <td style="color:${pumpColor}; font-weight:bold;">${d.pump>0?'+':''}${d.pump.toFixed(2)}%</td>
                <td>${historyHtml}</td>
                <td style="font-size:0.85em; font-weight:bold; color:#777;">${statusHtml}</td>
            </tr>`;
        });

        if(keys.length === 0) html = `<tr><td colspan="9" style="padding:20px; color:#555">No matches found.</td></tr>`;
        tbody.innerHTML = html;
    }

    function updateTableUI() { renderTable(); }
    function updateBtcUI(c) {
        document.getElementById('btc-price').innerText = parseFloat(c.lastPrice).toLocaleString();
        const chg = parseFloat(c.priceChangePercent);
        const el = document.getElementById('btc-change');
        el.innerText = (chg>0?"+":"") + chg.toFixed(2) + "%";
        el.style.color = chg>=0?"#00e676":"#ff1744";
    }
</script>
</body>
</html>